 ; Ŀ
 ;   halo.lsp - update various attributes in one of several title blocks.  
 ;   Copyright 1997, 2000, 2001, 2002, 2003 by Rocket Software Ltd.        
 ;   You aren't good enough to use this routine - but go ahead anyway.     
 ;                                                                         
 ;   Halo reads information into the titleblock from the data file         
 ;   JobNo.txt which is located in the directory containing the current    
 ;   drawing.  If it isn't found then nothing is changed.                  
 ; 

 ; Ŀ
 ;   SsDevo - update an ss of PennWest_A1_Titleblock blocks.               
 ; 
 (DEFUN SSDEVO (ss joblst / client title1 lsd num enam)
 ; Ŀ
 ;   Split the list up into project name variables.                        
 ; 
  (setq ourproj  (nth 0 joblst))    ; our project number
  (setq dproj    (nth 1 joblst))    ; Devon's project number
  (setq areaname (nth 2 joblst))    ; area name
  (setq line1    (nth 3 joblst))    ; title line 1
  (setq lsd      (nth 4 joblst))    ; LSD (title line 3)
 ; Ŀ
 ;   Update each block in the selection set.                               
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (devo enam ourproj dproj areaname line1 lsd)
         (setq num (1+ num)))
 (princ))
 ; Ŀ
 ;   SsDevo end.                                                           
 ; 

 ; Ŀ
 ;   Devo - update a single Devon-d insertion.                             
 ;   Arguments: Enam, a block insertion ename.                             
 ;              and a set of new attribute values.                         
 ;   Calls Nooval to update atts depending on the values from the file.    
 ; 
 (DEFUN DEVO (enam ourproj dproj areaname line1 lsd / entt enam tagg)
 ; Ŀ
 ;   Step through the title block and install such values as are           
 ;   available.                                                            
 ; 
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                       (setq enam (entnext enam)))))))
         (setq tagg (cdr (assoc 2 entt)))
         (cond ((= tagg "DWG-NO")
                (setq dwgnam (strcase (getvar "dwgname")))
                (if (= (substr dwgnam (- (strlen dwgnam) 3)) ".DWG")
                    (setq dwgnam (substr dwgnam 1 (- (strlen dwgnam) 4))))
                (entmod (subst (cons 1 dwgnam) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The remainder use data from the Jobno.txt file.                       
 ; 
               ((= tagg "JOB-NO")
                (nooval entt ourproj))
               ((= tagg "DEV-PROJ-NO")
                (nooval entt dproj))
               ((= tagg "AREANAME")
                (nooval entt areaname))
               ((= tagg "FACILITYNAME")
                (nooval entt line1))
               ((= tagg "LSD.")
                (nooval entt lsd))))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Devo end.                                                             
 ; 

 ; Ŀ
 ;   SsPengo - update an ss of PennWest_A1_Titleblock blocks.              
 ; 
 (DEFUN SSPENGO (ss joblst / client title1 lsd num enam)
 ; Ŀ
 ;   Split the list up into project name variables.                        
 ; 
  (setq ourproj (nth 0 joblst))    ; our project number
  (setq pwproj  (nth 1 joblst))    ; Penn West's project number
  (setq lsd     (nth 2 joblst))    ; LSD
  (setq line1   (nth 3 joblst))    ; title line 1
 ; Ŀ
 ;   Update each block in the selection set.                               
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (pengo enam ourproj pwproj lsd line1)
         (setq num (1+ num)))
 (princ))
 ; Ŀ
 ;   SsPengo end.                                                          
 ; 

 ; Ŀ
 ;   Pengo - update a single PennWest_A1_Titleblock insertion.             
 ;   Arguments: Enam, a block insertion ename.                             
 ;              and a set of new attribute values.                         
 ;   Calls Nooval to update atts depending on the values from the file.    
 ; 
 (DEFUN PENGO (enam ourproj pwproj lsd line1 / entt enam tagg)
 ; Ŀ
 ;   Step through the title block and install such values as are           
 ;   available.                                                            
 ; 
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                       (setq enam (entnext enam)))))))
         (setq tagg (cdr (assoc 2 entt)))
         (cond ((member tagg '("CADFILE" "DWG.NO"))
                (setq dwgnam (strcase (getvar "dwgname")))
                (if (= (substr dwgnam (- (strlen dwgnam) 3)) ".DWG")
                    (setq dwgnam (substr dwgnam 1 (- (strlen dwgnam) 4))))
                (entmod (subst (cons 1 dwgnam) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The remainder use data from the Jobno.txt file.                       
 ; 
               ((= tagg "CONSUL_PROJ_NO")
                (nooval entt ourproj))
               ((= tagg "PWP_PROJ#")
                (nooval entt pwproj))
               ((= tagg "AREA/LSD")
                (nooval entt lsd))
               ((= tagg "PROJECT_NAME")
                (nooval entt line1))))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Pengo end.                                                            
 ; 

 ; Ŀ
 ;   Nujem - update a single Gemini Gca1tb block insertion.                
 ;   Arguments: Enam, a block insertion ename.                             
 ;              and a set of new attribute values.                         
 ;   Calls Nooval to update atts depending on the values from the file.    
 ; 
 (DEFUN NUJEM (enam proj client clien2 line1 line2 lsd / entt enam tagg)
 ; Ŀ
 ;   Step through the title block and install such values as are           
 ;   available.                                                            
 ; 
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                       (setq enam (entnext enam)))))))
         (setq tagg (cdr (assoc 2 entt)))
         (cond ((= tagg "DWGNUM")
                (setq dwgnam (strcase (getvar "dwgname")))
                (if (= (substr dwgnam (- (strlen dwgnam) 3)) ".DWG")
                    (setq dwgnam (substr dwgnam 1 (- (strlen dwgnam) 4))))
                (entmod (subst (cons 1 dwgnam) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The next attributes use data from the Jobno.txt file.                 
 ; 
               ((or (= tagg "CLIENT") (= tagg "CLIENT1"))
                (nooval entt client))
               ((= tagg "CLIENT2")
                (nooval entt clien2))
               ((= tagg "CLIENT1")
                (nooval entt client))
               ((= tagg "CLIENT2")
                (nooval entt clien2))
               ((= tagg "LINE1")
                (nooval entt line1))
               ((= tagg "LINE2")
                (nooval entt line2))
               ((= tagg "CLIENT")
                (nooval entt client))
               ((= tagg "JOBNUM")
                (nooval entt proj))
               ((= tagg "SLOCATION")
                (nooval entt LSD))))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Nujem end.                                                            
 ; 

 ; Ŀ
 ;   Nuje - update an ss of new Gemini GCA1TB Tbs.                         
 ; 
 (DEFUN NUJE (ss joblst / client title1 lsd num enam)
 ; Ŀ
 ;   Split the list up into project name variables.                        
 ;   There are two types of Gca1tb blocks, one with two client name lines  
 ;   and one with only one, so this will be kludgy.                        
 ; 
  (setq proj   (nth 0 joblst))    ; project
  (setq client (nth 1 joblst))    ; Client name line 1
  (setq line1  (nth 2 joblst))    ; Title line 1
  (setq line2  (nth 3 joblst))    ; Title line 2
  (setq lsd    (nth 4 joblst))    ; LSD
  (setq clien2 (nth 5 joblst))    ; Client name line 2
 ; Ŀ
 ;   Update each block in the selection set.                               
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (nujem enam proj client clien2 line1 line2 lsd)
         (setq num (1+ num)))
 (princ))
 ; Ŀ
 ;   Nuje end.                                                             
 ; 

 ; Ŀ
 ;   Ssnow - update an ss of Snowdon Tbs.                                  
 ; 
 (DEFUN SSNOW (ss joblst / client title1 lsd num enam)
 ; Ŀ
 ;   Split the list up into project name variables.                        
 ; 
  (setq client (nth 0 joblst))    ; Client name
  (setq title1 (nth 1 joblst))    ; Title line 1
  (setq lsd    (nth 2 joblst))    ; Title line 2 (LSD)
 ; Ŀ
 ;   Update each block in the selection set.                               
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (snowb enam client title1 lsd)
         (setq num (1+ num)))
 (princ))
 ; Ŀ
 ;   Ssnow end.                                                            
 ; 

 ; Ŀ
 ;   Snowb - update a single Snowdon Consulting Snow-tb block insertion.   
 ;   Arguments: Enam, a block insertion ename.                             
 ;              and a set of new attribute values.                         
 ;   Calls Nooval to update atts depending on the values from the file.    
 ; 
 (DEFUN SNOWB (enam client title1 lsd / entt enam tagg)
 ; Ŀ
 ;   Step through the title block and install such values as are           
 ;   available.                                                            
 ; 
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                      (setq enam (entnext enam)))))))
         (setq tagg (cdr (assoc 2 entt)))
         (cond ((= tagg "DWGNO")
                (setq dwgnam (strcase (getvar "dwgname")))
                (if (= (substr dwgnam (- (strlen dwgnam) 3)) ".DWG")
                    (setq dwgnam (substr dwgnam 1 (- (strlen dwgnam) 4))))
                (entmod (subst (cons 1 dwgnam) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The next three attributes use data from the Jobno.txt file.           
 ; 
               ((= tagg "CLIENT")
                (nooval entt client))
               ((= tagg "TITLE1")
                (nooval entt title1))
               ((= tagg "TITLE2")
                (nooval entt lsd))))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Snowb end.                                                            
 ; 

 ; Ŀ
 ;   UpUp - update an ss of Upside Tbs.                                    
 ; 
 (DEFUN UPUP (ss joblst / enam projnm lsd projno client)
 ; Ŀ
 ;   Split the list up into project name variables.                        
 ; 
  (setq projnm (nth 0 joblst))      ; Project name
  (setq lsd (nth 1 joblst))         ; LSD
  (setq projno (nth 2 joblst))      ; Project number
  (setq client (nth 3 joblst))      ; Client name
 ; Ŀ
 ;   Update each block in the selection set.                               
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (burp enam projnm lsd projno client)
         (setq num (1+ num)))
 (princ))
 ; Ŀ
 ;   UpUp end.                                                             
 ; 

 ; Ŀ
 ;   Burp - update a single Upside D-Bord-E block insertion.               
 ;   Arguments: Enam, a block insertion ename.                             
 ;              and a set of new attribute values.                         
 ;   Calls Nooval to update atts depending on the values from the file.    
 ; 
 (DEFUN BURP (enam projnm lsd projno client / entt enam tagg)
 ; Ŀ
 ;   Step through the title block and install such values as are           
 ;   available.                                                            
 ; 
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                      (setq enam (entnext enam)))))))
         (setq tagg (cdr (assoc 2 entt)))
         (cond ((or (= tagg "DWG.NO") (= tagg "DRAWINGNO."))
                (setq dwgnam (strcase (getvar "dwgname")))
                (if (= (substr dwgnam (- (strlen dwgnam) 3)) ".DWG")
                    (setq dwgnam (substr dwgnam 1 (- (strlen dwgnam) 4))))
                (entmod (subst (cons 1 dwgnam) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The next four attributes use data from the Jobno.txt file.            
 ; 
               ((= tagg "PROJECT")
                (nooval entt projnm))
               ((= tagg "LSD")
                (nooval entt lsd))
               ((= tagg "PROJNO")
                (nooval entt projno))
               ((= tagg "CLIENT")
                (nooval entt client))))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Burp end.                                                             
 ; 

 ; Ŀ
 ;   Jet - update an ss of Gemini Tbs.                                     
 ; 
 (DEFUN JET (ss joblst / client title1 title2 proj lsd num enam)
 ; Ŀ
 ;   Split the list up into project name variables.                        
 ; 
  (setq proj (nth 0 joblst))      ; Project number
  (setq client (nth 1 joblst))    ; Client nanme
  (setq title1 (nth 2 joblst))    ; Title line 1
  (setq title2 (nth 3 joblst))    ; Title line 2
  (setq lsd (nth 4 joblst))       ; LSD - mechanical only
 ; Ŀ
 ;   Update each block in the selection set.                               
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (glup enam client title1 title2 proj lsd)
         (setq num (1+ num)))
 (princ))
 ; Ŀ
 ;   Jet end.                                                              
 ; 

 ; Ŀ
 ;   Nooval - update an attribute depending on the value of a string.      
 ;   If the string is ## then empty the attribute, if it is "" or * then   
 ;   don't touch it, otherwise put the string into the attribute.          
 ;   Arguments: Entt, the entity data list for the attribute.              
 ;              Val, an attribute value.                                   
 ;   Returns nothing.                                                      
 ; 
 (DEFUN NOOVAL (entt val /)
  (cond ((= val "##")
         (entmod (subst (cons 1 "") (assoc 1 entt) entt)))
        ((and val (/= val "") (/= val "*"))
         (entmod (subst (cons 1 val) (assoc 1 entt) entt))))
 (princ))
 ; Ŀ
 ;   Nooval end.                                                           
 ; 

 ; Ŀ
 ;   Glup - update a single Gemini title block insertion.                  
 ;   Arguments: Enam, a block insertion ename.                             
 ;              and a set of new attribute values.                         
 ;   Returns nothing.                                                      
 ; 
 (DEFUN GLUP (enam client title1 title2 proj lsd / entt enam tagg)
 ; Ŀ
 ;   Step through the title block and install such values as are           
 ;   available.                                                            
 ; 
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                      (setq enam (entnext enam)))))))
         (setq tagg (cdr (assoc 2 entt)))
         (cond ((= tagg "GEMINI_DWG_NO")
                (setq dwgnam (strcase (getvar "dwgname")))
                (if (= (substr dwgnam (- (strlen dwgnam) 3)) ".DWG")
                    (setq dwgnam (substr dwgnam 1 (- (strlen dwgnam) 4))))
                (entmod (subst (cons 1 dwgnam) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The next four attributes use data from the Jobno.txt file.            
 ; 
               ((= tagg "CLIENT")
                (nooval entt client))
               ((= tagg "TITLE_1ST_LINE")
                (nooval entt title1))
               ((= tagg "TITLE_2ND_LINE")
                (nooval entt title2))
               ((= tagg "PROJECT_NO")
                (nooval entt proj))
 ; Ŀ
 ;   The Location tag is only present in the mechanical title block,       
 ;   so this will never be a condition for an electrical tb, and will be   
 ;   ignored by Nooval if there is no value.                               
 ; 
               ((= tagg "LOCATION")
                (nooval entt lsd))))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Glup end.                                                             
 ; 

 ; Ŀ
 ;   Hoat - update an ss of PCP TBs.                                       
 ; 
 (DEFUN HOAT (ss joblst / jobno proj1 proj2 mainfc area lsd site sitlsd cd1
                                                   cd min hour stime num enam)
 ; Ŀ
 ;   Split the list up into project name variables.                        
 ; 
  (setq jobno (nth 0 joblst))    ; Our job number
  (setq proj1 (nth 1 joblst))    ; Project line 1
  (setq proj2 (nth 2 joblst))    ; Project line 2
  (setq mainfc (nth 3 joblst))   ; Main Facility
  (setq area (nth 4 joblst))     ; Area
  (setq lsd (nth 5 joblst))      ; Main LSD
  (setq site (nth 6 joblst))     ; Site
  (setq sitlsd (nth 7 joblst))   ; Site LSD
  (setq epcm (nth 8 joblst))     ; Epcm Co.
 ; Ŀ
 ;   Get the current date and time.                                        
 ; 
  (setq cd1 (rtos (getvar "CDATE") 2 4))
  (setq cd (strcat "Date and Time Saved: "
                   (substr cd1 1 4) "."
                   (substr cd1 5 2) "."
                   (substr cd1 7 2)))
  (setq min (substr cd1 12 2)
        hour (atoi (substr cd1 10 2)))
  (if (>= hour 12)
      (setq hour (itoa (- hour 12))
            ampm "pm")
      (setq hour (itoa hour)
            ampm "am"))
  (if (= "0" hour)
      (setq hour "12"))
  (setq stime (strcat hour ":" min ampm))     
 ; Ŀ
 ;   Update each block in the selection set.                               
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (halop enam jobno proj1 proj2 mainfc area
                     lsd site sitlsd epcm stime cd)
         (setq num (1+ num)))
 (princ))
 ; Ŀ
 ;   Hoat end.                                                             
 ; 

 ; Ŀ
 ;   Halop - update a single PCP block insertion.                          
 ;   Arguments: Enam, a block insertion ename.                             
 ;              and a set of new attribute values.                         
 ;   Returns nothing.                                                      
 ; 
 (DEFUN HALOP (enam jobno proj1 proj2 mainfc area lsd site sitlsd epcm stime cd
                                                  / entt enam tagg dwgnam len)
 ; Ŀ
 ;   Step through the title block and install such values as are           
 ;   available.                                                            
 ; 
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                      (setq enam (entnext enam)))))))
         (setq tagg (cdr (assoc 2 entt)))
         (cond ((= tagg "FILE1")
                (entmod (subst (cons 1 "FILE:") (assoc 1 entt) entt)))
               ((= tagg "FILE2")
                (setq dwgnam (phath (strcat (getvar "dwgprefix")
                                            (getvar "dwgname"))))
                (entmod (subst (cons 1 dwgnam) (assoc 1 entt) entt)))
 ; Ŀ
 ;   These attributes use data from the Jobno.txt file.                    
 ; 
               ((= tagg "EPCM-NM")
                (nooval entt jobno))
               ((= tagg "PROJNAM1")
                (nooval entt proj1))
               ((= tagg "PROJNAM2")
                (nooval entt proj2))
               ((= tagg "FACILITY")
                (nooval entt mainfc))
               ((= tagg "AREA-NAME")
                (nooval entt area))
               ((= tagg "LOCATION")
                (nooval entt lsd))
               ((= tagg "SITE-NM")
                (nooval entt site))
               ((= tagg "SITE-LSD")
                (nooval entt sitlsd))
               ((= tagg "CONSULTANT")
                (nooval entt epcm))
 ; Ŀ
 ;   The rest are stuff that can be extracted from the environment.        
 ; 
               ((or (= tagg "PCP-FILE-NO") (= tagg "ENCANA-FILE-NO"))
                (setq dwgnam (strcase (getvar "dwgname")))
                (setq len (strlen dwgnam))
                (if (= (substr dwgnam (- len 3)) ".DWG")
                    (setq dwgnam (substr dwgnam 1 (- len 4))))
                (entmod (subst (cons 1 dwgnam) (assoc 1 entt) entt)))
               ((= tagg "STIME")
                (entmod (subst (cons 1 stime) (assoc 1 entt) entt)))
               ((= tagg "SDATE")
                (entmod (subst (cons 1 cd) (assoc 1 entt) entt)))))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Halop end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen name1))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Getcfg - read the configuration file into a list.                     
 ;   Takes one argument, the config file name.                             
 ;   Removes comments and leading and trailing spaces.                     
 ;   Returns the configuration list.                                       
 ; 
 (DEFUN GETCFG (fn / str len stop cfglst)
 ; Ŀ
 ;   Open the data file and make the configuration list.                   
 ; 
  (if (setq fn (open fn "r"))
      (progn
           (while (and (null stop) (setq str (read-line fn)))
                  (while (= (substr str 1 1) " ")
                         (setq str (substr str 2)))
                  (if (and (/= (substr str 1 1) ";")
                           (/= str ""))
                      (progn
                           (setq str (car (splat ";" str)))
                           (while (= (substr str (setq len (strlen str))) " ")
                                  (setq str (substr str 1 (1- len))))
                           (if (= (strcase str t) "notes:")
                               (setq stop t)
                               (setq cfglst (cons str cfglst))))))
           (close fn)))
 (reverse cfglst))
 ; Ŀ
 ;   Getcfg end.                                                           
 ; 

 ; Ŀ
 ;   Phath - correct the case of a text string, typically a path.          
 ;   If a path, each directory name is capitalized, if a string the first  
 ;   character is capitalized.  All other characters are in lower case.    
 ;   Takes one argument, a string, which it returns, corrected.            
 ; 
 (DEFUN PHATH (str / strlst sub newstr)
  (setq strlst (splat "\\" str))
  (while (setq sub (car strlst))
         (setq strlst (cdr strlst))
         (setq sub (strcat (strcase (substr sub 1 1))
                           (strcase (substr sub 2) t)))
         (if (null newstr)
             (setq newstr sub)
             (setq newstr (strcat newstr "\\" sub))))
 newstr)
 ; Ŀ
 ;   Phath end.                                                            
 ; 

 ; Ŀ
 ;   Halo.                                                                 
 ; 
 (DEFUN C:HALO (/ ss slan fnam joblst blnam)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Title/data block acquisition: see whose drawing we are in.            
 ;   (Assumes that all TBs in one drawing are the same block.)             
 ;   1. Pcp title blocks.                                                  
 ; 
  (if (or (setq ss (ssget "X" (list (cons 2 "T-A002A"))))
          (setq ss (ssget "X" (list (cons 2 "T2A"))))
          (setq ss (ssget "X" (list (cons 2 "T2A-3"))))
          (setq ss (ssget "X" (list (cons 2 "REPL-A1"))))
          (setq ss (ssget "X" (list (cons 2 "PCPA1"))))
 ; Ŀ
 ;   2. Gemini title blocks.                                               
 ; 
          (setq ss (ssget "X" (list (cons 2 "GEIELCTB"))))
          (setq ss (ssget "X" (list (cons 2 "GEIA1TB"))))
          (setq ss (ssget "X" (list (cons 2 "GCA1TB"))))
 ; Ŀ
 ;   3. Penn West title blocks.                                            
 ; 
          (setq ss (ssget "X" (list (cons 2 "PennWest_A1_Titleblock"))))
          (setq ss (ssget "X" (list (cons 2 "PennWest_D_Titleblock"))))
 ; Ŀ
 ;   4. Snowdon Consulting.                                                
 ; 
          (setq ss (ssget "X" (list (cons 2 "SNOW-TB"))))
 ; Ŀ
 ;   5. Upside electrical title blocks.                                    
 ; 
          (setq ss (ssget "X" (list (cons 2 "D-BORD-E"))))
 ; Ŀ
 ;   6. Devon.                                                             
 ; 
          (setq ss (ssget "X" (list (cons 2 "DEVON-D")))))
      (progn
 ; Ŀ
 ;   Count the title blocks...                                             
 ; 
           (if (< 1 (setq slan (sslength ss)))
               (prompt (strcat "\n** Caution - " (itoa slan) " "
                               (cdr (assoc 2 (entget (ssname ss 0))))
                               " title blocks. **")))
 ; Ŀ
 ;   See if the Jobno.txt data file is available; read it into a list.     
 ; 
           (setq fnam (strcat (getvar "dwgprefix") "jobno.txt"))
           (if (and (setq fnam (findfile fnam))
                    (setq joblst (getcfg fnam)))
               (progn
 ; Ŀ
 ;   Decide which title block have found, act accordingly.                 
 ; 
                    (setq blnam (strcase
                                     (cdr (assoc 2 (entget (ssname ss 0))))))
 ; Ŀ
 ;   Pcp title blocks.                                                     
 ; 
                    (cond ((member blnam '("T-A002A" "T2A" "T2A-3"
                                           "REPL-A1" "PCPA1"))
                           (hoat ss joblst)
 ; Ŀ
 ;   Last ditch check for the rare and stupid Pcp overlay block.           
 ; 
                           (if (setq ss (ssget "X" (list (cons 2 "PCPTITLE"))))
                               (prompt
                                 "\nYou must explode the Pcptitle insert.\n")))
 ; Ŀ
 ;   Penn West - there may be other title blocks, so far we have only      
 ;   seen this one.  These two.                                            
 ; 
                          ((member blnam '("PENNWEST_A1_TITLEBLOCK"
                                           "PENNWEST_D_TITLEBLOCK"))
                           (sspengo ss joblst))
 ; Ŀ
 ;   Snowdon Consulting blocks.                                            
 ; 
                          ((member blnam '("SNOW-TB"))
                           (ssnow ss joblst))
 ; Ŀ
 ;   Gemini title blocks.                                                  
 ; 
 ; *** Geia1tb may or may not work - it hasn't been tested yet, there doesn't
 ; seem to be a copy available, and we may or may not still use it.
                          ((member blnam '("GEIELCTB" "GEIA1TB"))
                           (jet ss joblst))
 ; Ŀ
 ;   The new (est) Gemini title block.                                     
 ; 
                          ((member blnam '("GCA1TB"))
                           (nuje ss joblst))
 ; Ŀ
 ;   Upside title blocks.                                                  
 ; 
                          ((member blnam '("D-BORD-E"))
                           (upup ss joblst))
 ; Ŀ
 ;   Devon title blocks.                                                   
 ; 
                          ((member blnam '("DEVON-D"))
                           (ssdevo ss joblst)))
 ; Ŀ
 ;   Indicate which Jobno.tx file was used.                                
 ; 
                    (prompt (strcat "\nUsing Job File: " fnam
                                    ", Job No: " (car joblst) "\n")))
 ; Ŀ
 ;   Or mention (and remember) that the file wasn't available.             
 ;   Removed: Halo is pretty archaic and this reminder isn't that useful.  
 ; 
 ;             (prompt "\n** Job No. File Not Found. **\n")
                                                           )))
 (princ))